## 16.1 非齐次线性方程组 
### 16.1.1 基础概念
##### **定义**： #非齐次线性方程组
> <font color="#ccc1d9">描述：</font> $\begin{cases}a_{11}x_{1}+a_{12}x_{2}+\cdots+a_{1n}x_{n}=b_{1},\\a_{21}x_{1}+a_{22}x_{2}+\cdots+a_{2n}x_{n}=b_{2},\\\cdots\cdots\\a_{m1}x_{1}+a_{m2}x_{2}+\cdots+a_{mn}x_{n}=b_{m}\end{cases}$

**解释**
+ 概念： 
	+ 其称为 `m` 个方程，`n` 个未知量的非齐次线性方程组；
	+ 因此还得到了多的一列，即为增广矩阵；
+ 解释： 
	+ 其实就是把 $x_{1}\alpha_{1}+x_{2}\alpha_{2}+\cdots+x_{n}\alpha_{n}=0$ 变成了 $x_{1}\alpha_{1}+x_{2}\alpha_{2}+\cdots+x_{n}\alpha_{n}=b$ 

### 16.1.2 非齐次线性方程组 
**概念**：有解的条件 
+ 若 $r\left(A\right)\neq r\left(\left[A,b\right]\right)\quad\left(\boldsymbol{b}\text{ 不能由 }\alpha_{1},\alpha_{2},\cdots,\alpha_{n}\text{线性表示 }\right)\quad$，则方程组 (II)无解；
	+ `->` 增加了一个向量组 `b`（列）后，使得矩阵升了一维，即标识向量组 `b` 和 `A` 中其他向量组线性无关；
	+ `->` b 不在 `A` 的解空间当中；
	+ `->` 所以加了 `b` 之后方程组无解；
+ 若 $r\left(A\right)=r\left(\left[A,b\right]\right)=n\quad\left(\text{即}a_{1},a_{2},\cdots,a_{n}\text{线性无关，}a_{1},a_{2},\cdots,a_{n},b\text{线性相关 }\right)\quad$，则方程组 (II)有唯一解；
	+ `->` 列数，即向量组个数等于秩数，因此方程组满秩；
	+ `->` 没有多余自由的自由度，因此只有唯一解；
+ 若 $r\left(A\right)=r\left(\left[A,b\right]\right)=r<n\quad$，则方程组 (II)有无穷多解.
	+ `->` 自由度 > 真实约束的个数，所以有无穷多解；

**概念**：解的性质 
+ $\text{设}\eta_1,\eta_2,\eta\text{ 是非齐次线性方程组}Ax=b\text{ 的解},\xi\text{是对应齐次线性方程组 }Ax=0\text{ 的解,则:}$
+ ${(1) }\eta_1-\eta_2$ 是 `Ax=0` 的解 `->` 任意的两个非齐次的特解的差，一定是齐次的解；
+ $(2)k\xi+\eta 是Ax=b$ 的解 `->` $k\xi+\eta$ 是非齐次的解；

## 16.2 求解方法与步骤 
**方法**：非齐次线性方程求解方法 
+ 第一步： 
	+ 写出 `Ax=b` 的导出方程组 `Ax=0`，并求 `Ax=0` 的通解：$k_{1}\xi_{1}+k_{2}\xi_{2}+\cdots+k_{n-r}\xi_{n-r}$
	+ 即：先和齐次线性方程一样，求出其通解；
+ 第二步： 
	+ 求出 `Ax=b` 的一个特解 $\eta$
	+ 即：求出当前非齐次方程的特解；
	+ 注：这个特解不具有唯一性；
+ 第三步： 
	+ $Ax=b\text{ 的通解为 }k_{1}\xi_{1}+k_{2}\xi_{2}+\cdots+k_{n-r}\xi_{n-r}+\eta,\text{其中}k_{1},k_{2},\cdots,k_{n-r}$ 为任意常数；
	+ `非齐次方程的通解 = 齐次方程通解 + 非齐次方程一个特解`；

**补充**：关于非齐次方程组解的条件与结论 `->` 矩阵的秩 
+ 前提：矩阵 $A_{m*n}$
+ 行满秩：`m=r(A)`
	+ 因为已经满秩了，所以再添列也是多余的，因此加上的非齐次项就是多余的项，且方程组有解；
+ 列满秩：`n=r(A)`
	+ 如果是齐次方程：未知变量个数和真是约束个数相同；
	+ 但在非齐次当中，因为是 `r(A)=r(A|b)=n` ，所以不一定；
+ 方程组有无穷多解的条件：`r(A)=r(A|b)<n`

**结论**：关于 $A^{T}Ax=A^{T}b$ 的解
+ 如果 $A^{T}x=b$ 无解 `->` $A^{T}Ax=A^{T}b$ 求得最佳近似解；

**结论**：$r(A)=r(A^T)=r(AA^T)=r(A^TA)$